/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.server.netty;

import io.moquette.parser.netty.MQTTDecoder;
import io.moquette.parser.netty.MQTTEncoder;
import io.moquette.server.ServerAcceptor;
import io.moquette.server.config.IConfig;
import io.moquette.server.netty.MoquetteIdleTimeoutHandler;
import io.moquette.server.netty.NettyMQTTHandler;
import io.moquette.server.netty.metrics.BytesMetrics;
import io.moquette.server.netty.metrics.BytesMetricsCollector;
import io.moquette.server.netty.metrics.BytesMetricsHandler;
import io.moquette.server.netty.metrics.MessageMetrics;
import io.moquette.server.netty.metrics.MessageMetricsCollector;
import io.moquette.server.netty.metrics.MessageMetricsHandler;
import io.moquette.spi.impl.ProtocolProcessor;
import io.moquette.spi.security.ISslContextCreator;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAcceptor
implements ServerAcceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NettyAcceptor.class);
    EventLoopGroup m_bossGroup;
    EventLoopGroup m_workerGroup;
    BytesMetricsCollector m_bytesMetricsCollector = new BytesMetricsCollector();
    MessageMetricsCollector m_metricsCollector = new MessageMetricsCollector();

    @Override
    public void initialize(ProtocolProcessor processor, IConfig props, ISslContextCreator sslCtxCreator) throws IOException {
        this.m_bossGroup = new NioEventLoopGroup();
        this.m_workerGroup = new NioEventLoopGroup();
        NettyMQTTHandler handler = new NettyMQTTHandler(processor);
        this.initializePlainTCPTransport(handler, props);
        this.initializeWebSocketTransport(handler, props);
        String sslTcpPortProp = props.getProperty("ssl_port");
        String wssPortProp = props.getProperty("secure_websocket_port");
        if (sslTcpPortProp != null || wssPortProp != null) {
            SSLContext sslContext = sslCtxCreator.initSSLContext();
            if (sslContext == null) {
                LOG.error("Can't initialize SSLHandler layer! Exiting, check your configuration of jks");
                return;
            }
            this.initializeSSLTCPTransport(handler, props, sslContext);
            this.initializeWSSTransport(handler, props, sslContext);
        }
    }

    private void initFactory(String host, int port, final PipelineInitializer pipeliner) {
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.m_bossGroup, this.m_workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                try {
                    pipeliner.init(pipeline);
                }
                catch (Throwable th) {
                    LOG.error("Severe error during pipeline creation", th);
                    throw th;
                }
            }
        }).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        try {
            ChannelFuture f = b.bind(host, port);
            LOG.info("Server binded host: {}, port: {}", (Object)host, (Object)port);
            f.sync();
        }
        catch (InterruptedException ex) {
            LOG.error(null, ex);
        }
    }

    private void initializePlainTCPTransport(final NettyMQTTHandler handler, IConfig props) throws IOException {
        final MoquetteIdleTimeoutHandler timeoutHandler = new MoquetteIdleTimeoutHandler();
        String host = props.getProperty("host");
        int port = Integer.parseInt(props.getProperty("port"));
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)timeoutHandler);
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWebSocketTransport(final NettyMQTTHandler handler, IConfig props) throws IOException {
        String webSocketPortProp = props.getProperty("websocket_port");
        if (webSocketPortProp == null) {
            LOG.info("WebSocket is disabled");
            return;
        }
        int port = Integer.parseInt(webSocketPortProp);
        final MoquetteIdleTimeoutHandler timeoutHandler = new MoquetteIdleTimeoutHandler();
        String host = props.getProperty("host");
        this.initFactory(host, port, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) {
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqtt, mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)timeoutHandler);
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeSSLTCPTransport(final NettyMQTTHandler handler, IConfig props, final SSLContext sslContext) throws IOException {
        String sslPortProp = props.getProperty("ssl_port");
        if (sslPortProp == null) {
            LOG.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        LOG.info("Starting SSL on port {}", (Object)sslPort);
        final MoquetteIdleTimeoutHandler timeoutHandler = new MoquetteIdleTimeoutHandler();
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", NettyAcceptor.this.createSslHandler(sslContext));
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)timeoutHandler);
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    private void initializeWSSTransport(final NettyMQTTHandler handler, IConfig props, final SSLContext sslContext) throws IOException {
        String sslPortProp = props.getProperty("secure_websocket_port");
        if (sslPortProp == null) {
            LOG.info("SSL is disabled");
            return;
        }
        int sslPort = Integer.parseInt(sslPortProp);
        final MoquetteIdleTimeoutHandler timeoutHandler = new MoquetteIdleTimeoutHandler();
        String host = props.getProperty("host");
        this.initFactory(host, sslPort, new PipelineInitializer(){

            @Override
            void init(ChannelPipeline pipeline) throws Exception {
                pipeline.addLast("ssl", NettyAcceptor.this.createSslHandler(sslContext));
                pipeline.addLast("httpEncoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("httpDecoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("webSocketHandler", (ChannelHandler)new WebSocketServerProtocolHandler("/mqtt", "mqtt mqttv3.1, mqttv3.1.1"));
                pipeline.addLast("ws2bytebufDecoder", (ChannelHandler)new WebSocketFrameToByteBufDecoder());
                pipeline.addLast("bytebuf2wsEncoder", (ChannelHandler)new ByteBufToWebSocketFrameEncoder());
                pipeline.addFirst("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, 10));
                pipeline.addAfter("idleStateHandler", "idleEventHandler", (ChannelHandler)timeoutHandler);
                pipeline.addFirst("bytemetrics", (ChannelHandler)new BytesMetricsHandler(NettyAcceptor.this.m_bytesMetricsCollector));
                pipeline.addLast("decoder", (ChannelHandler)new MQTTDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new MQTTEncoder());
                pipeline.addLast("metrics", (ChannelHandler)new MessageMetricsHandler(NettyAcceptor.this.m_metricsCollector));
                pipeline.addLast("handler", (ChannelHandler)handler);
            }
        });
    }

    @Override
    public void close() {
        if (this.m_workerGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        if (this.m_bossGroup == null) {
            throw new IllegalStateException("Invoked close on an Acceptor that wasn't initialized");
        }
        Future workerWaiter = this.m_workerGroup.shutdownGracefully();
        Future bossWaiter = this.m_bossGroup.shutdownGracefully();
        try {
            workerWaiter.await(100L);
        }
        catch (InterruptedException iex) {
            throw new IllegalStateException(iex);
        }
        try {
            bossWaiter.await(100L);
        }
        catch (InterruptedException iex) {
            throw new IllegalStateException(iex);
        }
        MessageMetrics metrics = this.m_metricsCollector.computeMetrics();
        LOG.info("Msg read: {}, msg wrote: {}", (Object)metrics.messagesRead(), (Object)metrics.messagesWrote());
        BytesMetrics bytesMetrics = this.m_bytesMetricsCollector.computeMetrics();
        LOG.info(String.format("Bytes read: %d, bytes wrote: %d", bytesMetrics.readBytes(), bytesMetrics.wroteBytes()));
    }

    private ChannelHandler createSslHandler(SSLContext sslContext) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(false);
        return new SslHandler(sslEngine);
    }

    abstract class PipelineInitializer {
        PipelineInitializer() {
        }

        abstract void init(ChannelPipeline var1) throws Exception;
    }

    static class ByteBufToWebSocketFrameEncoder
    extends MessageToMessageEncoder<ByteBuf> {
        ByteBufToWebSocketFrameEncoder() {
        }

        protected void encode(ChannelHandlerContext chc, ByteBuf bb, List<Object> out) throws Exception {
            BinaryWebSocketFrame result = new BinaryWebSocketFrame();
            result.content().writeBytes(bb);
            out.add(result);
        }
    }

    static class WebSocketFrameToByteBufDecoder
    extends MessageToMessageDecoder<BinaryWebSocketFrame> {
        WebSocketFrameToByteBufDecoder() {
        }

        protected void decode(ChannelHandlerContext chc, BinaryWebSocketFrame frame, List<Object> out) throws Exception {
            ByteBuf bb = frame.content();
            bb.retain();
            out.add(bb);
        }
    }
}

