import datetime
import urllib2
import time
import paho.mqtt.client as mqtt
import json
import base64
from datetime import datetime

mqtt_borker_address = "212.98.137.194"
mqtt_port = 1883
emonApiKey="fe497879fdeaf259920d6fb5e9838f0b" # Put your Write API here

# Configuration parameters 
sensor_devEUI = "9c29da12cc778339"
actuator_devEUI = "62458a10bf05d852" 
applicationID = "7"

# The callback for when the client receives a CONNACK response from the server.
def on_connect(client, userdata, flags, rc):
    print("Connected with result code "+str(rc))
    
    # Subscribe to all received messages by demo application
    subscribe_topic = "application/"+applicationID+"/node/+/rx"
    
    # Subscribing in on_connect() means that if we lose the connection and
    # reconnect then subscriptions will be renewed.
    client.subscribe(subscribe_topic)

def on_message(client, userdata, msg):
	print(msg.topic+" "+str(msg.payload))
	data = json.loads(msg.payload)
	
	# Get device uniaue identifier
	devEUI = data['devEUI'] 
	
	# Discard empty messages
	if 'data' not in data.keys():
		return 0
	
	json_payload = json.loads(base64.b64decode(data['data']))
	
	if devEUI == sensor_devEUI:
		moisture =  json_payload['M'];
		moisture_perc = 100-(100*(float(moisture)-370)/(1023-370));
		json_txt = "{moisture:" + "%.2f"%moisture_perc + "}"
		push_to_emoncms(json_txt, sensor_devEUI)
		
		# Publish in actuator topic to turn on the LED
		publish_topic = "application/"+applicationID+"/node/"+actuator_devEUI+"/tx"
		if moisture_perc <= 30:
			client.publish(publish_topic,'{"reference": "fossdemo","confirmed": false,"fPort": 10,"data": "b24="}')
		else: 
			client.publish(publish_topic,'{"reference": "fossdemo","confirmed": false,"fPort": 10,"data": "b2Zm"}')
	
	elif devEUI == actuator_devEUI:
		led =  json_payload['L'];
		json_txt = "{led:" + "%d"%led + "}"
		print json_txt
		push_to_emoncms(json_txt, actuator_devEUI)
	else: 
		return 0

def push_to_emoncms(json_txt, devEUI):
    # Prepare the URL 
    url  ="http://emoncms.org/" +  "input/post.json?node="+ str(devEUI) + "&apikey=" + emonApiKey + "&json=" + urllib2.quote(json_txt)
    
    # Send the data to emoncms
    try:
        urllib2.urlopen(url)
        #print url
    except urllib2.URLError, e:
        print "Oops, timed out?"
    except socket.timeout:
        print "Timed out!"
        
client = mqtt.Client()
#client.username_pw_set("username", "password")
client.on_connect = on_connect
client.on_message = on_message

client.connect(mqtt_borker_address, mqtt_port, 60)

# Blocking call that processes network traffic, dispatches callbacks and
# handles reconnecting.
# Other loop*() functions are available that give a threaded interface and a
# manual interface.
client.loop_forever()
