import datetime
import urllib2
import time
import paho.mqtt.client as mqtt
import json
import base64
from datetime import datetime
import csv
from matplotlib.dates import DateFormatter
import matplotlib.pyplot as plt

mqtt_borker_address = "212.98.137.194"
mqtt_port = 1883
device_eui_list = []
device_name_list = ['eguz']

emonApiKey="fe497879fdeaf259920d6fb5e9838f0b" # Put your Write API here

# The callback for when the client receives a CONNACK response from the server.
def on_connect(client, userdata, flags, rc):
    print("Connected with result code "+str(rc))

    # Subscribing in on_connect() means that if we lose the connection and
    # reconnect then subscriptions will be renewed.
    client.subscribe("application/6/node/a013f31833bd35a3/rx")

def on_message(client, userdata, msg):
    print(msg.topic+" "+str(msg.payload))
    data = json.loads(msg.payload)
    devEUI = data['devEUI']
    nodeName = data['nodeName']
    
    if devEUI not in device_eui_list:
    	device_eui_list.append(devEUI)

    if nodeName not in device_name_list:
        return 0

    if 'data' not in data.keys():
        return 0

    json_payload = json.loads(base64.b64decode(data['data']))
    
    temperature =  json_payload['T'];
    light =  json_payload['L'];
    moisture =  json_payload['M'];
    
    if 'B' in json_payload:
        battery_volt = json_payload['B'];

    moisture_perc = 100-(100*(float(moisture)-370)/(1023-370));
#    rssi = data['rssi']
    server_time = datetime.now()
    
    json_txt = "{temp:" + "%.2f"%temperature
    json_txt += ",light:" + "%.2f"%light
    if 'B' in json_payload:
        json_txt += ",battery:" + "%.2f"%battery_volt
    json_txt += ",moisture:" + "%.2f"%moisture_perc + "}"
    # Prepare the URL 
    url  ="http://emoncms.org/" +  "input/post.json?node="+ str(devEUI) + "&apikey=" + emonApiKey + "&json=" + urllib2.quote(json_txt)
    
    # Send the data to emoncms
    try:
        urllib2.urlopen(url)
        #print url
    except urllib2.URLError, e:
        print "Oops, timed out?"
    except socket.timeout:
        print "Timed out!"

client = mqtt.Client()
#client.username_pw_set("username", "password")
client.on_connect = on_connect
client.on_message = on_message

client.connect(mqtt_borker_address, mqtt_port, 60)

# Blocking call that processes network traffic, dispatches callbacks and
# handles reconnecting.
# Other loop*() functions are available that give a threaded interface and a
# manual interface.
client.loop_forever()
