from xml.dom.minidom import parseString
from datetime import datetime
from dateutil import tz
import os, sys
import matplotlib.pyplot as plt # getting specific plotting functions
import pandas as pd # nice data utilities

#convert from GPS time (UTC) to our local time zone
from_zone = tz.gettz('UTC')
to_zone = tz.gettz('Europe/Paris')  #Eastern Standard Time (EST)

print sys.argv

fname = sys.argv[1]
doc = open(fname).read()
dom = parseString(doc)

pts = dom.getElementsByTagName('trkpt')

csv_lines = []
for pt in pts:
    line = []
    #print pt
    #timestamp
    time_str = pt.getElementsByTagName("time")[0].firstChild.data
    gps_dt = datetime.strptime(time_str, "%Y-%m-%dT%H:%M:%S.%fZ")
    utc_dt = gps_dt.replace(tzinfo=from_zone)
    est_dt = utc_dt.astimezone(to_zone)
    ts = est_dt.strftime("%s") #convert to Unix Epoch seconds
    line.append(ts)
    #lattitude
    line.append(pt.attributes['lat'].value)
    #longitude
    line.append(pt.attributes['lon'].value)
    #elevation
    line.append(pt.getElementsByTagName("ele")[0].firstChild.data)
    #speed
    #line.append(pt.getElementsByTagName("x:speed")[0].firstChild.data)
    line.append('0')
    #format and append line
    csv_lines.append(",".join(line))
    
#finish up by smashing all the lines together
csv_string = "\n".join(csv_lines)

#save the data in a suitably named file
base, ext = os.path.splitext(fname)
csv_filename = "%s.csv" % base
outfile = open(csv_filename, 'w')
outfile.write(csv_string)
outfile.close()

# Do some plotting 
D = pd.read_table(csv_filename, 
                  header = 0, 
                  sep    =',',
                  names  = ['time','lat','lon', 'ele', 'x_speed']);


fig = plt.figure(figsize=(15,15))
ax1 = fig.add_subplot(411)
ax2 = fig.add_subplot(412)
ax3 = fig.add_subplot(413)
ax4 = fig.add_subplot(414)
ax1.plot(D.time, D.lat,     'r');
ax2.plot(D.time, D.lon,     'b');
ax3.plot(D.time, D.ele,     'g');
ax4.plot(D.time, D.x_speed, 'c');
ax1.set_ylabel('Lat');
ax2.set_ylabel('Long');
ax3.set_ylabel('Ele');
ax4.set_ylabel('Speed');

fig.savefig('./images/gps_plot.png');
plt.show();