
# coding: utf-8

# In[4]:

import os, sys
import pandas as pd 

fname = sys.argv[1]; #this file is created by running gpx_to_csv.ipynb
gps_track = pd.read_table(fname, 
                          header = 0,
                          sep    = ',',
                          names  = ['time','lat','lon','ele','x_speed','RSSI','RSSI_err']
                         );
                         
# pip install folium
import folium

ZOOM_LEVEL = 16
FOLIUM_LINE_OPTIONS = dict(opacity=1.0, weight=4)

#get a central GPS location over which to generate a map
lat_avg = gps_track.lat.mean()
lon_avg = gps_track.lon.mean()

map_osm = folium.Map(location=[lat_avg,lon_avg],zoom_start=ZOOM_LEVEL)


prev_pt = gps_track.loc[0]

for i, pt in gps_track.loc[1:].iterrows(): #iterate over each "row" in the DataFrame after the first
    prev_coord = (prev_pt.lat,prev_pt.lon)
    coord      = (pt.lat,pt.lon)
    loc = [prev_coord,coord]
    #signal strength 
    s = pt.RSSI
    pt_color = None
    if (s > -85 and s < 0):         #strong signal
        pt_color ='green'   
    elif (s < -85 and s > -95):       #acceptable signal
        pt_color ='blue' 
    elif (s < -95 and s > -110):      #marginal signal
        pt_color ='yellow'
    elif (s < -110):                #very low or no signal, NaNs will get this color
        pt_color ='red'
        
    l = folium.PolyLine(locations=loc, color=pt_color, **FOLIUM_LINE_OPTIONS)
    map_osm.add_children(l)
    prev_pt = pt
    
map_osm

map_osm.save('./images/rssi_map.html');

# In[ ]:



